/*
** nester - NES emulator
** Copyright (C) 2000  Darren Ranalli
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

#ifndef _NES_H_
#define _NES_H_

#include <stdio.h>

#include "../GBA_main.h"

#if !defined(__GNUC__)
#define memset_gba memset
#define memmove_gba memmove
#define memcpy_gba memcpy
#endif

#include "../types.h"
#include "../emulator.h"
#include "cpu/NES_6502.h"
#include "mapper/NES_mapper.h"
#include "NES_ROM.h"
#include "ppu/NES_PPU.h"
//#include "apu/NES_APU_wrapper.h"
#include "NES_pad.h"
#include "NES_settings.h"

#include "libsnss/libsnss.h"

//class NES_screen_mgr;

//extern NES_pad* pad1;
//extern NES_pad* pad2;
//extern NES_PPU* ppu;

#define NESINLINE __inline

extern nesMapper_t *NES_mapper;
extern uint8 NES_SaveRAM[0x2000];

#define NES_NUM_COLORS 64
extern uint8 NES_RGB_pal[NES_NUM_COLORS][3];

  int NES_FakeConstructor(void);

  //void new_snd_mgr(sound_mgr* _sound_mgr);

//  void set_pad1(controller* c) { pad1 = (NES_pad*)c; }
//  void set_pad2(controller* c) { pad2 = (NES_pad*)c; }

  static NESINLINE nesMapper_t* NES_get_mapper(void) { return NES_mapper; }

  boolean NES_emulate_frame(boolean draw);

  void NES_reset();

  const char* NES_getROMname();
  const char* NES_getROMnameExt();
  const char* NES_getROMpath();
//  NES_ROM* get_NES_ROM();

  boolean NES_loadState(const char* fn);
  boolean NES_saveState(const char* fn);

  void NES_calculate_palette();

  static NESINLINE uint8 NES_getBGColor() { return PPU_getBGColor(); }

  enum {
    NES_NUM_VBLANK_LINES = 20,
    NES_NUM_FRAME_LINES = 240,

    // these are 0-based, and actions occur at start of line
    NES_NMI_LINE = 241,
    NES_VBLANK_FLAG_SET_LINE = 241,
    NES_VBLANK_FLAG_RESET_LINE = 261,
    NES_SPRITE0_FLAG_RESET_LINE = 261,

    NES_COLOR_BASE = 0x40 // NES palette is set starting at color 0x40 (64)
    //NES_NUM_COLORS = 64    // 64 colors in the NES palette
  };

  // these are called by the CPU
  uint8 NES_MemoryRead(uint32 addr);
  void  NES_MemoryWrite(uint32 addr, uint8 data);

  int NES_loadROM(const char* fn);
  void NES_freeROM();

  void NES_onFreeze();
  void NES_onThaw();

  // internal read/write functions
  uint8 NES_ReadRAM(uint32 addr);
  void  NES_WriteRAM(uint32 addr, uint8 data);
  
  uint8 NES_ReadLowRegs(uint32 addr);
  void  NES_WriteLowRegs(uint32 addr, uint8 data);
  
  uint8 NES_ReadHighRegs(uint32 addr);
  void  NES_WriteHighRegs(uint32 addr, uint8 data);

  void  NES_emulate_CPU_cycles(float num_cycles);
  void  NES_trim_cycle_counts();

  // file stuff
  void NES_Save_SaveRAM();
  void NES_Load_SaveRAM();

  uint8 *NES_GetRAM(void);
#endif
